/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class ServerActions {
    public static void swapTool(Player player, double scrollDelta) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            int i;
            ItemStackHandler inv = CapabilityUtils.getBackpackInv(player).getToolSlotsHandler();
            if (ContainerUtils.isEmpty(inv)) {
                return;
            }
            int toolSlots = inv.getSlots();
            int lastSlot = toolSlots - 1;
            int j = 0;
            for (int i2 = 0; i2 <= lastSlot; ++i2) {
                if (inv.getStackInSlot(i2).m_41619_()) continue;
                ++j;
            }
            ItemStack[] tools = new ItemStack[j];
            int slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                tools[slot] = inv.getStackInSlot(i).m_41777_();
                ++slot;
            }
            ServerActions.swapTool(scrollDelta, tools, player);
            slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                inv.setStackInSlot(i, tools[slot]);
                ++slot;
            }
        }
    }

    public static void swapTool(double delta, ItemStack[] tools, Player player) {
        int i;
        ItemStack tempStack;
        if (delta > 0.0) {
            tempStack = tools[0];
            for (i = 0; i <= tools.length - 1; ++i) {
                if (i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = player.m_21205_();
                    player.m_21008_(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i + 1];
            }
        }
        if (delta < 0.0) {
            tempStack = tools[tools.length - 1];
            for (i = tools.length - 1; i >= 0; --i) {
                if (i - 1 < 0) {
                    tools[0] = player.m_21205_();
                    player.m_21008_(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i - 1];
            }
        }
    }

    public static void equipBackpack(Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            if (!CapabilityUtils.isWearingBackpack(player)) {
                if (player.f_36096_ instanceof TravelersBackpackItemMenu) {
                    ((ServerPlayer)player).m_6915_();
                }
                ItemStack stack = player.m_21205_().m_41777_();
                CapabilityUtils.getCapability(player).ifPresent(cap -> {
                    cap.setWearable(stack);
                    cap.setContents(stack);
                });
                player.m_21205_().m_41774_(1);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
            } else {
                ((ServerPlayer)player).m_6915_();
                player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.equip_otherbackpack"));
            }
        }
    }

    public static void unequipBackpack(Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && CapabilityUtils.isWearingBackpack(player)) {
            if (player.f_36096_ instanceof TravelersBackpackItemMenu) {
                ((ServerPlayer)player).m_6915_();
            }
            ItemStack backpack = CapabilityUtils.getWearingBackpack(player).m_41777_();
            if (!player.m_150109_().m_36054_(backpack)) {
                player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.unequip_nospace"));
                return;
            }
            CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.05f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
            CapabilityUtils.synchronise(player);
            CapabilityUtils.synchroniseToOthers(player);
        }
    }

    public static void switchAbilitySlider(Player player, boolean sliderValue) {
        TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
        container.setAbility(sliderValue);
        container.setDataChanged(7, 4);
        if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, container.getItemStack()) && !sliderValue) {
            BackpackAbilities.ABILITIES.abilityRemoval(container.getItemStack(), player);
        }
        if (container.getItemStack().m_41720_() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get() && container.getLastTime() <= 0) {
            BackpackAbilities.ABILITIES.chickenAbility(player, true);
        }
    }

    public static void switchAbilitySliderBlockEntity(Player player, BlockPos pos, boolean sliderValue) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            blockEntity2.setAbility(sliderValue);
            blockEntity2.setDataChanged();
            blockEntity2.m_58904_().m_46672_(pos, blockEntity2.m_58900_().m_60734_());
            if (blockEntity2.m_58900_().m_60734_() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                ((TravelersBackpackBlock)blockEntity2.m_58900_().m_60734_()).tryAbsorbWater(blockEntity2.m_58904_(), pos);
            }
        }
    }

    public static void sortBackpack(Player player, byte screenID, byte button, boolean shiftPressed) {
        AbstractContainerMenu abstractContainerMenu;
        if (screenID == 3 && (abstractContainerMenu = player.f_36096_) instanceof TravelersBackpackBlockEntityMenu) {
            TravelersBackpackBlockEntityMenu menu = (TravelersBackpackBlockEntityMenu)abstractContainerMenu;
            if (player.m_9236_().m_7702_(menu.container.getPosition()) instanceof TravelersBackpackBlockEntity) {
                ContainerSorter.selectSort(menu.container, player, button, shiftPressed);
            }
        } else if (screenID == 1) {
            AbstractContainerMenu abstractContainerMenu2 = player.f_36096_;
            if (abstractContainerMenu2 instanceof TravelersBackpackItemMenu) {
                TravelersBackpackItemMenu menu = (TravelersBackpackItemMenu)abstractContainerMenu2;
                ContainerSorter.selectSort(menu.container, player, button, shiftPressed);
            }
        } else if (screenID == 2) {
            ContainerSorter.selectSort(CapabilityUtils.getBackpackInv(player), player, button, shiftPressed);
        }
    }

    public static void toggleVisibility(Player player) {
        ItemStack stack = CapabilityUtils.getWearingBackpack(player);
        boolean visibility = stack.m_41782_() && stack.m_41783_().m_128441_("Visibility") ? stack.m_41783_().m_128471_("Visibility") : true;
        stack.m_41784_().m_128379_("Visibility", !visibility);
        CapabilityUtils.synchronise(player);
        CapabilityUtils.synchroniseToOthers(player);
    }

    public static void toggleSleepingBag(Player player, BlockPos pos) {
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            if (!blockEntity2.isSleepingBagDeployed()) {
                if (!blockEntity2.deploySleepingBag(level, pos)) {
                    player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.deploy_sleeping_bag"));
                }
            } else {
                blockEntity2.removeSleepingBag(level, blockEntity2.getBlockDirection());
            }
            if (!level.f_46443_) {
                ((ServerPlayer)player).m_6915_();
            }
        }
    }

    public static void emptyTank(double tankType, Player player, Level level, byte screenID) {
        FluidTank tank;
        ITravelersBackpackContainer container = null;
        if (screenID == 2) {
            container = CapabilityUtils.getBackpackInv(player);
        }
        if (screenID == 1) {
            container = ((TravelersBackpackItemMenu)player.f_36096_).container;
        }
        if (screenID == 3) {
            container = ((TravelersBackpackBlockEntityMenu)player.f_36096_).container;
        }
        if (container == null) {
            return;
        }
        FluidTank fluidTank = tank = tankType == 1.0 ? container.getLeftTank() : container.getRightTank();
        if (!level.f_46443_) {
            level.m_5594_(null, player.m_20183_(), FluidUtils.getFluidEmptySound(tank.getFluid().getFluid()), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        tank.drain(container.getTier().getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
        container.setDataChanged(4);
    }

    public static boolean setFluidEffect(Level level, Player player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, level, (Entity)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (Entity)player, level);
        }
        return done;
    }

    public static void switchHoseMode(Player player, double scrollDelta) {
        ItemStack hose = player.m_21205_();
        if (hose.m_41720_() instanceof HoseItem && hose.m_41783_() != null) {
            int mode = HoseItem.getHoseMode(hose);
            if (scrollDelta > 0.0) {
                if (++mode == 4) {
                    mode = 1;
                }
            } else if (scrollDelta < 0.0 && --mode == 0) {
                mode = 3;
            }
            hose.m_41783_().m_128405_("Mode", mode);
        }
    }

    public static void toggleHoseTank(Player player) {
        ItemStack hose = player.m_21205_();
        if (hose.m_41720_() instanceof HoseItem && hose.m_41783_() != null) {
            int tank = HoseItem.getHoseTank(hose);
            tank = tank == 1 ? 2 : 1;
            hose.m_41783_().m_128405_("Tank", tank);
        }
    }
}

